<?php
defined('PF_VERSION') OR exit('Access denied');
class Pf_Demodata_Controller extends Pf_Plugin_Controller
{
    private $rules = array(
        'name' => 'required|min_len,2|max_len,255',
        'description' => 'max_len,255'
    );
    public function __construct()
    {
        parent::__construct();
        $this->view->set_path('demodata');
    }
    public function main(){
        $this->data['run']=false;

        $url = admin_url('admin-page=demodata', false);
        if($this->input->has_get('token')){
            if(Pf_Plugin_CSRF::is_valid($this->input->get('token'),'data_demo')){
                $this->data['run']=true;
            }else{
                Pf_Plugin_Redirect::to('&act=main&token');
            }
        }

        $this->data['url'] = $url;
        $this->view->render('demodata/main', $this->data);
    }
    private function completeInstallation(){
        $completeMessage =
            'Installation complete. ' .
            'Please refresh or go to /admin page to manage your website.';
        return json_encode(array('message' => $completeMessage));
    }
    public function complete(){
        if(is_ajax()){
            ini_set('max_execution_time', 100);
            $step = $this->input->post('step');
            $fuc = "process".$step;
            if(function_exists($fuc)){
                call_user_func($fuc);
            }else if($step=="c-cf"){
                die($this->completeInstallation());
            }
            die(json_encode(array('success' => true)));
        }
    }
}